<?php

class GroupController extends CkltController {
    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
            'postOnly + delete', // we only allow deletion via POST request
        );
    }

/**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */

    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
//    public function actionCreate() {
//        $model = new Group;
//        Yii::app()->clientScript->scriptMap = array('jquery.js' => false,);
//        // Uncomment the following line if AJAX validation is needed
//        $this->performAjaxValidation($model);
//        $flag = true;
//        if (isset($_POST['Group'])) {
//            $flag = false;
//            $model->attributes = $_POST['Group'];
//            if ($model->save()) {
//                $adminModel = new Group('search');
//                $model->unsetAttributes();  // clear any default values
//                $this->redirect('admin');
//            }
//        }
//        $this->render('create', array(
//            'model' => $model,
//        ));
//    }

    public function actionCreate(){
        $model = new Group;
//        Yii::app()->clientScript->scriptMap = array('jquery.js' => false,);
        // Uncomment the following line if AJAX validation is needed
        $this->performAjaxValidation($model);
        $flag = true;
        if (isset($_POST['Group'])) {
            $flag = false;
            $model->attributes = $_POST['Group'];
            if ($model->save()) {
                $adminModel = new Group('search');
                $model->unsetAttributes();  // clear any default values
                $this->redirect('admin');
            }
        }
        if(Yii::app()->request->isAjaxRequest){
            $this->renderPartial('create', array('model' => $model), false, true);
        }else{
            $this->render('create', array('model' => $model,));
        }
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Group'])) {
            $model->attributes = $_POST['Group'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        $this->loadModel($id)->delete();

        // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
        if (!isset($_GET['ajax']))
            $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('Group');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new Group('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Group']))
            $model->attributes = $_GET['Group'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }


    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer $id the ID of the model to be loaded
     * @return Group the loaded model
     * @throws CHttpException
     */
    public function loadModel($id) {
        $model = Group::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param Group $model the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'group-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function getGroupList() {
        $arrGroups = array();
        $groups = Group::model()->findAll(array(
                    "select" => "id, title",
                    "order" => "title",
                    "group" => "title",
                ));
        foreach ($groups as $group) {
            $arrGroups[$group->id] = $group->title;
        }
        return $arrGroups;
    }

}
