<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pinjaman extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->model('PinjamanModel');
		$this->load->library('excel');
	}

	public function index()
	{
		$this->load->library('session');
		$this->load->model('PinjamanModel');
		if($this->session->userdata('logged_in'))
		{
			if($this->session->userdata('status') == 0)
			{
				$data = array();
			}
			else
			{
				redirect('Pinjaman/indexadmin');
			}
		}	
		else
		{
			redirect('Pinjaman/login');
		}
		$this->load->view('home_pinjaman_view', $data);
	}

	public function signup()
	{
		$this->load->model('PinjamanModel');
		$this->load->library('form_validation');

		if($this->input->post('register'))
		{
			$this->form_validation->set_rules('username', 'Username', 'required|min_length[4]');
			$this->form_validation->set_rules('fullname', 'Fullname', 'required|min_length[6]');
			$this->form_validation->set_rules('email', 'Email', 'required|valid_email');
			$this->form_validation->set_rules('password', 'Password', 'required|callback_valid_password');
			$this->form_validation->set_rules('repassword', 'RePassword', 'required|matches[password]');

			$username = $this->input->post('username');
			$fullname = $this->input->post('fullname');
			$email = $this->input->post('email');
			$password = hash('sha256', $this->input->post('password'));

			$data['users'] = $this->PinjamanModel->get_user();

			if($data['users']->num_rows() == 0)
			{
				$data = array(
				'id'=> null,
				'username'=> $username,
				'fullname'=> $fullname, 
				'email'=> $email, 
				'password'=> $password,
				'status'=> TRUE,
				'is_approved'=> TRUE
				);
			}
			else
			{
				$data = array(
				'id'=> null,
				'username'=> $username,
				'fullname'=> $fullname, 
				'email'=> $email, 
				'password'=> $password,
				'status'=> FALSE,
				'is_approved'=> FALSE
				);
			}

			if(isset($data) && $this->form_validation->run() == true)
			{
				$insert = $this->PinjamanModel->signup($data);
				redirect('Pinjaman/login');
			}
			else
			{
				echo validation_errors();
			}
		}

		$this->load->helper('form');
		$this->load->view('signup_pinjaman_view');

	}

	public function indexadmin()
	{
		$this->load->model('PinjamanModel');
		if($this->session->userdata('logged_in'))
		{
			if($this->session->userdata('status') == 1)
			{
				$data = array();
			}
			else
			{
				redirect('Pinjaman/index');
			}
		}
		else
		{
			redirect('Pinjaman/login');
		}	
		$this->load->view('pinjaman_adminview', $data);
	}

	public function show_NonValidateUsers()
	{
		if($this->session->userdata('logged_in'))
		{
			$data['users'] = $this->PinjamanModel->getNonAuthorized();
			$this->load->view('pinjaman_nonuserview', $data);
		}
	}

	public function show_ValidateUsers()
	{
		if($this->session->userdata('logged_in'))
		{
			$data['users'] = $this->PinjamanModel->getAuthorized();
			$this->load->view('pinjaman_userview', $data);
		}
	}

	public function login_validasi()
	{	
		$this->load->library('session');
		$this->load->library('form_validation');
		$this->load->model('PinjamanModel');

		if($this->input->post('login'))
		{
			$this->form_validation->set_rules('username', 'Username', 'required|min_length[4]');
			$this->form_validation->set_rules('password', 'Password', 'required');
			
			$username = $this->input->post('username');
			$password = hash('sha256', $this->input->post('password'));	

			$result = $this->PinjamanModel->login($username, $password);

			if($result && $this->form_validation->run() == true)
			{
				foreach ($result as $row) 
				{
					$sess_array = array(
						'id' => $row->id,
						'username' => $username,
						'status' => $row->status,
						'is_approved' => $row->is_approved,
						'logged_in' => TRUE
					);
				    $this->session->set_userdata($sess_array);
				}
				if($sess_array['is_approved'] == 1)
				{
				 	if($sess_array['id'] == 1)
					{
				   		redirect('Pinjaman/indexadmin');
				 	}
				 	else
				  		redirect('Pinjaman/index');
				}
				else if($sess_array['is_approved'] == 0)
				{
				 	$this->session->set_flashdata('login', 'Admin have not granted you access to the site. Please wait!');
				 	redirect('Pinjaman/login');
				}
			}  
			else 
			{
				redirect('Pinjaman/login');
			}
		}
	}

	public function logout()
	{
		$this->load->library('session');
		
		$id = $this->session->userdata('id');
		$username = $this->session->userdata('username');
		$status = $this->session->userdata('status');
		$is_approved = $this->session->userdata('is_approved');

		$sess_array = array($id, $username, $status, $is_approved, 'logged_in' => FALSE);
		
		$this->session->unset_userdata($sess_array);
		$this->session->sess_destroy();

		redirect('Pinjaman/login');
	}

	public function valid_password($password)
	{
		//credited to https://forum.codeigniter.com/thread-66889-post-339273.html
		$password = trim($password);
		$regex_lowercase = '/[a-z]/';
		$regex_uppercase = '/[A-Z]/';
		$regex_number = '/[0-9]/';
		$regex_special = '/[!@#$%^&*()\-_=+{};:,<.>§`~]/';

		if(empty($password))
		{
			$this->form_validation->set_message('valid_password', 'The {field} field is required');
			return FALSE;
		}
		
		if(preg_match_all($regex_lowercase, $password) < 1)
		{
			$this->form_validation->set_message('valid_password', 'The {field} field must be at least one lowercase letter.');
			return FALSE;
		}

		if(preg_match_all($regex_uppercase, $password) < 1 )
		{
			$this->form_validation->set_message('valid_password', 'The {field} field must be at least one uppercase letter.');
			return FALSE;
		}

		if(preg_match_all($regex_number, $password) < 1)
		{
			$this->form_validation->set_message('valid_password', 'The {field} field must be at least one number.');
			return FALSE;
		}

		if (preg_match_all($regex_special, $password) < 1)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must have at least one special character.' . ' ' . htmlentities('!@#$%^&*()\-_=+{};:,<.>§`~]'));
            return FALSE;
        }

        if (strlen($password) < 6)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must be at least 6 characters in length.');
            return FALSE;
        }

        return TRUE;
	}

	public function get_autocomplete()
	{
		if(isset($_GET['term']))
		{
			$result = $this->PinjamanModel->get_complete($_GET['term']);
			if(count($result) > 0)
			{
				foreach ($result as $row) 
				{
					$result_array[] = $row->nim;
				}
				echo json_encode($result_array);
			}
		}
	}

	public function search()
	{
		if($this->session->userdata('logged_in'))
		{

			$search = $this->input->get('search');
			$data['search1'] = $this->PinjamanModel->search($search);
			$this->load->view('cari_pinjaman_view', $data);
			
		}
	}

	public function giveAuthorize($param1 = '')
	{
		if($this->session->userdata('logged_in'))
		{
			$this->load->model('PinjamanModel');
			$result = $this->PinjamanModel->authorize($param1);
			redirect('Pinjaman/show_NonValidateUsers');
		}
	}

	public function deleteUser($param1 = '')
	{
		if($this->session->userdata('logged_in'))
		{
			$this->load->model('PinjamanModel');
			$result = $this->PinjamanModel->delete($param1);
			redirect('Pinjaman/indexadmin');	
		}
	}

	public function import()
	{
		if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			foreach ($object->getWorksheetIterator() as $worksheet) 
			{
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$nim = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
					$nama = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$tempatlahir = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$tanggallahir = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$status = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$data[] = array(
							'nim'			=> $nim,
							'nama'			=> $nama,
							'tempat_lhr' 	=> $tempatlahir,
							'tanggal_lhr'	=> $tanggallahir,
							'status'		=> $status
					);
				}
			}
			$this->PinjamanModel->import($data);
			echo 'Data imported successfully';
		}
	}

	public function export()
	{
		$this->load->library('excel');
		$object = new PHPExcel();

		$object->setActiveSheetIndex(0);

		$table_columns = array("Nim", "Nama Mahasiswa", "Prodi", "Pengajuan", "Acc WD 3", "Catatan");

		$column = 0;

		foreach($table_columns as $field)
		{
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
			$column++;
		}

		$data = $this->PinjamanModel->export();

		$excel_row = 2;

		foreach ($data as $row) 
		{
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->nim);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->nama);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->prodi);
			//$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->pengajuan);
			//$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->acc);
			//$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->catatan);
			$excel_row++;
		}

		$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel');
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="PengajuanPinjaman.xls"');
		$object_writer->save('php://output');
	}

	public function login()
	{
		$this->load->view('login_pinjaman_view');
	}

	public function data_mahasiswa()
	{
		if($this->session->userdata('logged_in'))
		{

			$this->load->view('data_mahasiswa_pinjaman_view');
		}
	}

	public function form_pengajuan()
	{
		if($this->session->userdata('logged_in'))
		{	
			$id = $_GET['id'];
			$data['detailPeminjaman'] = $this->PinjamanModel->getData2($id);
			$data['detailPeminjaman2'] = $this->PinjamanModel->getData3($id);
			$this->load->view('form_pengajuan_pinjaman_view', $data);
		}
	}

	function tambahkanPengajuan(){
		if($this->session->userdata('logged_in'))
		{
			$role = implode(',', $this->input->post('onecek'));
			$data = array(
				'ipk' => $this->input->post('ipk'),
				'no_hp' => $this->input->post('nohportu'),
				'no_hp_orang_tua' => $this->input->post('nohp'),
				'persyaratan' => $role.",".",".",".",",
				'pengajuan_pinjaman' => $this->input->post('pengajuan'),
				'disetujui_wd_3' => $this->input->post('wd3'),
				'catatan' => $this->input->post('catatan'),
				'nim' => $this->input->post('id1')
			);

			$data2 = array(
				'validasi' => 1 ,
				'status_peminjaman' => 1
			);

			$id = $this->input->post('id1');
			$this->PinjamanModel->insertPengajuan($data, $data2, $id);

			redirect('Pinjaman/search?search='.$id);
		}
	}

	function updateFormPengajuan(){
		if($this->session->userdata('logged_in'))
		{
			$role = implode(',', $this->input->post('onecek2'));
			$data = array(
				'ipk' => $this->input->post('ipk2'),
				'no_hp' => $this->input->post('nohportu2'),
				'no_hp_orang_tua' => $this->input->post('nohp2'),
				'persyaratan' => $role.",".",".",".",",
				'pengajuan_pinjaman' => $this->input->post('pengajuan2'),
				'disetujui_wd_3' => $this->input->post('wd32'),
				'catatan' => $this->input->post('catatan2'),
			);


			$id = $this->input->post('id2');
			$this->PinjamanModel->updatePengajuan($id, $data);

			redirect('Pinjaman/search?search='.$id);

		}	
	}

	function deletePengajuan(){
		$id = $_GET['id'];
		$delete = $this->PinjamanModel->deletePengajuan($id);
		redirect('Pinjaman/search?search='.$id);
	}


	public function detail()
	{
		if($this->session->userdata('logged_in'))
		{
			$id = $_GET['id'];
			$data['detailPeminjaman'] = $this->PinjamanModel->getData3($id);
			$this->load->view('detail_pinjaman_view', $data);
		}
	}

	function status_peminjaman(){
		if($this->session->userdata('logged_in'))
		{
		$this->load->database();
		$jumlah_data = $this->PinjamanModel->jumlah_data();
		$this->load->library('pagination');
		$config['base_url'] = base_url().'Pinjaman/status_peminjaman';
		$config['total_rows'] = $jumlah_data;
		$config['per_page'] = 5;
		
		$config['query_string_segment'] = 'start';
		$config['full_tag_open'] = '<nav><ul class="pagination" style="margin-top:0px">';
		$config['full_tag_close'] = '</ul></nav>';
		 
		$config['first_link'] = 'First';
		$config['first_tag_open'] = '<li>';
		$config['first_tag_close'] = '</li>';
		 
		$config['last_link'] = 'Last';
		$config['last_tag_open'] = '<li>';
		$config['last_tag_close'] = '</li>';
		 
		$config['next_link'] = 'Next';
		$config['next_tag_open'] = '<li>';
		$config['next_tag_close'] = '</li>';
		 
		$config['prev_link'] = 'Prev';
		$config['prev_tag_open'] = '<li>';
		$config['prev_tag_close'] = '</li>';
		 
		$config['cur_tag_open'] = '<li class="active"><a>';
		$config['cur_tag_close'] = '</a></li>';
		 
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';

		$from = $this->uri->segment(3);
		$this->pagination->initialize($config);		
		$data['detailPinjam']  = $this->PinjamanModel->data($config['per_page'],$from);
		$this->load->view('data_mahasiswa_pinjaman_view', $data);
		}
	}

	public function cari()
	{
		if($this->session->userdata('logged_in'))
		{
			$this->load->view('cari_pinjaman_view');
		}
	}



	public function Data()
	{
		if($this->session->userdata('logged_in'))
		{
			$this->load->view('data_pinjaman_view');
		}
	}
	



public function importdata()
 {

  error_reporting(0);
  if(isset($_FILES["import"]["name"]))
  {
   $path = $_FILES["import"]["tmp_name"];
   $object = PHPExcel_IOFactory::load($path);
   foreach($object->getWorksheetIterator() as $worksheet)
   {
    $highestRow = $worksheet->getHighestRow();
    $highestColumn = $worksheet->getHighestColumn();
    for($row=2; $row<=$highestRow; $row++)
    {
     $nim = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
     $nama = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
     $tempat_lhr = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
     $tgl_lhr = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
     $status = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
     $kode_prodi = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
     $status_peminjaman = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
     $data[] = array(
      'nim'  => $nim,
      'nama'   => $nama,
      'tempat_lhr'    => $tempat_lhr,
      'tgl_lhr'  => $tgl_lhr,
      'status'   => $status,
      'kode_prodi' => $kode_prodi,
      'status_peminjaman' => $status_peminjaman
     );
    }
   }
   $this->PinjamanModel->inserttodatabase($data);

  } 
  redirect("Pinjaman/data");
 }


}


?>