<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {
	public function index()
	{
		$this->load->database();
		$this->load->helper('url');
		$this->load->view('login_view');
	}

	public function dologin()
	{
		$this->load->library('session');
		$this->load->helper('url');
		$this->load->model('Usermodel');
		$username = $this->input->post('username');
		$password = $this->input->post('password');

		$result = $this->Usermodel->checkLogin($username, $password);
		if($result)
		{
			$sess_array = array();
			foreach($result as $row)
			{
				$sess_array = array(
					'id' => $row->id,
					'username' => $row->username);
				$this->session->set_userdata('logged_in', $sess_array);
			}
			redirect('Book', 'index');
		}
		else
		{
			$data['login_msg'] = "error username or password";
			$this->load->view('login_view', $data);
		}

	}

	public function doLogout()
	{
		$this->load->library('session');
		$this->load->helper('url');
		$this->load->model('Usermodel');

		$id = $this->session->userdata('id');
		$username = $this->session->userdata('username');


		$sess_array = array($id, $username);
		$this->session->unset_userdata('logged_out', $sess_array);

		$this->session->sess_destroy();
		redirect('login', 'index');
	}
}