<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PinjamanModel extends CI_Model {
	public function get_user()
	{
		$this->load->database();
		$users = $this->db->get('users');
		return $users;
	}

	public function login($username, $password)
	{
		$this->load->database();
		$this->db->select('id, username, status, is_approved');
		$this->db->where('username', $username);
		$this->db->where('password', $password);
		$this->db->limit(1);
		$query=$this->db->get('users');

		if($query->num_rows() == 1)
		{
			return $query->result();
		}
		else
		{
			$this->session->set_flashdata('error', 'error username or password');
		}
	}

	public function signup($data)
	{
		$this->load->database();

		$users = $this->db->get('users');
		if($users->num_rows() == 0)
		{
			$query = $this->db->insert('users',$data);
			if($query)
			{
				$this->session->set_flashdata('successful', 'Your registration was successful. Now, you become an administrator.');
			}
			else
			{
				$this->session->set_flashdata('error', 'Something wrong.');
			}
		}
		else if($users->num_rows() < 7 && $users->num_rows() != 0)
		{
			$query = $this->db->insert('users',$data);
		
			if($query)
			{
				$this->session->set_flashdata('success', 'Your registration was successful. Please wait for admin approval.');
			}
			else
			{
				$this->session->set_flashdata('error', 'Something wrong.');
			}
		}
		else
		{
			$this->session->set_flashdata('', 'Database full. Cannot register anymore');
		}		
	}

	public function search($search)
	{
		$this->load->database();
		$this->db->select('nama, program_studi');
		$this->db->from('mahasiswa');
		if($search != '')
		{
			$this->db->like('nim', $search);
			$this->db->or_like('nama', $search);
		}
		$this->db->order_by('nim', 'ASC');
		return $this->db->get();
	}

	public function registrasi($nama, $nim, $fakultas, $programstudi, $ipk, $nohp, $nohportu, $persyaratan1, $persyaratan2, $persyaratan3, $persyaratan4, $pengajuanpinjaman, $wd3, $catatan)
	{
		$this -> load -> database();
		$this -> db -> select('nama, nim, fakultas, programstudi, ipk, nohp, nohportu, persyaratan1, persyaratan2, persyaratan3, persyaratan4, pengajuanpinjaman, wd3, catatan');
		$this -> db -> from('users');
		$this -> db -> where('nama', $nama);
		$this -> db -> where('nim', $nim);
		$this -> db -> where('fakultas', $fakultas);
		$this -> db -> where('program_studi', $programstudi);
		$this -> db -> where('ipk', $ipk);
		$this -> db -> where('no_hp', $nohp);
		$this -> db -> where('no_hp_ortu', $nohportu);
		$this -> db -> where('ktm', $persyaratan1);
		$this -> db -> where('khs', $persyaratan2);
		$this -> db -> where('invoice', $persyaratan3);
		$this -> db -> where('transkrip_nilai', $persyaratan4);
		$this -> db -> where('pengajuan_pinjaman', $pengajuanpinjaman);
		$this -> db -> where('persetujuan_pinjaman', $wd3);
		$this -> db -> where('catatan', $catatan);
		$this -> db -> limit(1);

		$query = $this -> db -> get();

		if($query -> num_rows() == 1)
		{
			return $query -> result();
		}
		else
		{
			return false;
		}
	}

	public function getNonAuthorized()
	{
		$this->load->database();
		$this->db->where('is_approved', 0);
		$users = $this->db->get('users');
		return $users;
	}

	public function getAuthorized()
	{
		$this->load->database();
		$this->db->where('is_approved', 1);
		$this->db->where('id!=', 1);
		$users = $this->db->get('users');
		return $users;
	}

	public function authorize($param1 = '')
	{
		$this->load->database();
		$data = array(
			'is_approved'=>1
		);
		$this->db->where('id', $param1);
		$query = $this->db->update('users', $data);
		if($query)
		{
			$this->session->set_flashdata('updatesuccess', 'User approval successful');
		}
		else
		{
			$this->session->set_flashdata('error', 'Something wrong.');
		}
	}

	public function delete($param1 = '')
	{
		$this->load->database();
		$this->db->where('id', $param1);
		$query = $this->db->delete('users');
		if($query)
		{
			$this->session->set_flashdata('deletesuccess', 'Delete user successful');
		}
		else
		{
			$this->session->set_flashdata('error', 'Something wrong.');
		}
	}
}
?>