<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pinjaman extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->model('PinjamanModel');
	}

	public function index()
	{
		$this->load->library('session');
		$this->load->model('PinjamanModel');
		if($this->session->userdata('logged_in'))
		{
			if($this->session->userdata('status') == 0)
			{
				$data = array();
			}
			else
			{
				redirect('Pinjaman/indexadmin');
			}
		}	
		else
		{
			redirect('Pinjaman/login');
		}
		$this->load->view('home_pinjaman_view', $data);
	}

	public function signup()
	{
		$this->load->model('PinjamanModel');
		$this->load->library('form_validation');

		if($this->input->post('register'))
		{
			$this->form_validation->set_rules('username', 'Username', 'required|min_length[4]');
			$this->form_validation->set_rules('fullname', 'Fullname', 'required|min_length[6]');
			$this->form_validation->set_rules('email', 'Email', 'required|valid_email');
			$this->form_validation->set_rules('password', 'Password', 'required|callback_valid_password');
			$this->form_validation->set_rules('repassword', 'RePassword', 'required|matches[password]');

			$username = $this->input->post('username');
			$fullname = $this->input->post('fullname');
			$email = $this->input->post('email');
			$password = hash('sha256', $this->input->post('password'));

			$data['users'] = $this->PinjamanModel->get_user();

			if($data['users']->num_rows() == 0)
			{
				$data = array(
				'id'=> null,
				'username'=> $username,
				'fullname'=> $fullname, 
				'email'=> $email, 
				'password'=> $password,
				'status'=> TRUE,
				'is_approved'=> TRUE
				);
			}
			else
			{
				$data = array(
				'id'=> null,
				'username'=> $username,
				'fullname'=> $fullname, 
				'email'=> $email, 
				'password'=> $password,
				'status'=> FALSE,
				'is_approved'=> FALSE
				);
			}

			if(isset($data) && $this->form_validation->run() == true)
			{
				$insert = $this->PinjamanModel->signup($data);
				redirect('Pinjaman/login');
			}
			else
			{
				echo validation_errors();
			}
		}

		$this->load->helper('form');
		$this->load->view('signup_pinjaman_view');

	}

	public function indexadmin()
	{
		$this->load->model('PinjamanModel');
		if($this->session->userdata('logged_in'))
		{
			if($this->session->userdata('status') == 1)
			{
				$data = array();
			}
			else
			{
				redirect('Pinjaman/index');
			}
		}
		else
		{
			redirect('Pinjaman/login');
		}	
		$this->load->view('pinjaman_adminview', $data);
	}

	public function show_NonValidateUsers()
	{
		$data['users'] = $this->PinjamanModel->getNonAuthorized();
		$this->load->view('pinjaman_nonuserview', $data);
	}

	public function show_ValidateUsers()
	{
		$data['users'] = $this->PinjamanModel->getAuthorized();
		$this->load->view('pinjaman_userview', $data);
	}

	public function login_validasi()
	{	
		$this->load->library('session');
		$this->load->library('form_validation');
		$this->load->model('PinjamanModel');

		if($this->input->post('login'))
		{
			$this->form_validation->set_rules('username', 'Username', 'required|min_length[4]');
			$this->form_validation->set_rules('password', 'Password', 'required');
			
			$username = $this->input->post('username');
			$password = hash('sha256', $this->input->post('password'));	

			$result = $this->PinjamanModel->login($username, $password);

			if($result && $this->form_validation->run() == true)
			{
				foreach ($result as $row) 
				{
					$sess_array = array(
						'id' => $row->id,
						'username' => $username,
						'status' => $row->status,
						'is_approved' => $row->is_approved,
						'logged_in' => TRUE
					);
				    $this->session->set_userdata($sess_array);
				}
				if($sess_array['is_approved'] == 1)
				{
				 	if($sess_array['id'] == 1)
					{
				   		redirect('Pinjaman/indexadmin');
				 	}
				 	else
				  		redirect('Pinjaman/index');
				}
				else if($sess_array['is_approved'] == 0)
				{
				 	$this->session->set_flashdata('login', 'Admin have not granted you access to the site. Please wait!');
				 	redirect('Pinjaman/login');
				}
			}  
			else 
			{
				redirect('Pinjaman/login');
			}
		}
	}

	public function logout()
	{
		$this->load->library('session');
		
		$id = $this->session->userdata('id');
		$username = $this->session->userdata('username');
		$status = $this->session->userdata('status');
		$is_approved = $this->session->userdata('is_approved');

		$sess_array = array($id, $username, $status, $is_approved, 'logged_in' => FALSE);
		
		$this->session->unset_userdata($sess_array);
		$this->session->sess_destroy();

		redirect('Pinjaman/login');
	}

	public function registrasi()
	{
		$this->load->view('pengajuan_pinjaman_view');
		$this->load->library('session');
		$this->load->helper('url');
		$this->load->model('PinjamanModel');
		$this->load->library('form_validation');

	}

	public function valid_password($password)
	{
		//credited to https://forum.codeigniter.com/thread-66889-post-339273.html
		$password = trim($password);
		$regex_lowercase = '/[a-z]/';
		$regex_uppercase = '/[A-Z]/';
		$regex_number = '/[0-9]/';
		$regex_special = '/[!@#$%^&*()\-_=+{};:,<.>§`~]/';

		if(empty($password))
		{
			$this->form_validation->set_message('valid_password', 'The {field} field is required');
			return FALSE;
		}
		
		if(preg_match_all($regex_lowercase, $password) < 1)
		{
			$this->form_validation->set_message('valid_password', 'The {field} field must be at least one lowercase letter.');
			return FALSE;
		}

		if(preg_match_all($regex_uppercase, $password) < 1 )
		{
			$this->form_validation->set_message('valid_password', 'The {field} field must be at least one uppercase letter.');
			return FALSE;
		}

		if(preg_match_all($regex_number, $password) < 1)
		{
			$this->form_validation->set_message('valid_password', 'The {field} field must be at least one number.');
			return FALSE;
		}

		if (preg_match_all($regex_special, $password) < 1)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must have at least one special character.' . ' ' . htmlentities('!@#$%^&*()\-_=+{};:,<.>§`~]'));
            return FALSE;
        }

        if (strlen($password) < 6)
        {
            $this->form_validation->set_message('valid_password', 'The {field} field must be at least 6 characters in length.');
            return FALSE;
        }

        return TRUE;
	}

	public function search()
	{
		$output = '';
		$search = '';
		$this->load->model('PinjamanModel');
		if($this->input->get('search'))
		{
			$search = $this->input->get('search');
			$data = $this->PinjamanModel->search($search);
			$output .= '<table>
							<thead>
								<tr>
									<th>Nama Mahasiswa</th>
									<th>Program Studi</th>
								</tr>
							</thead>';

			if($data->num_rows() > 0)
			{	
				foreach($data->result() as $row)
				{
					$output .= '<tbody>
									<tr>
										<td>'.$row->nama.'</td>
										<td>'.$row->program_studi.'</td>
										<td>Detail</td>
									</tr>
								</tbody>';
				}
			}
			else
			{
				$output .= '<tbody>
								<tr>
									<td> No Data found </td>
								</tr>
							</tbody>';
			}
			$output .= '</table>';
			echo $output;
		}
	}

	public function giveAuthorize($param1 = '')
	{
		$this->load->model('PinjamanModel');
		$result = $this->PinjamanModel->authorize($param1);
		redirect('Pinjaman/indexadmin');
	}

	public function deleteUser($param1 = '')
	{
		$this->load->model('PinjamanModel');
		$result = $this->PinjamanModel->delete($param1);
		redirect('Pinjaman/indexadmin');	
	}

	public function login()
	{
		$this->load->view('login_pinjaman_view');
	}

	public function footer()
	{
		$this->load->view('footer_peminjaman_view');
	}

	public function header(){
		$this->load->view('header_pinjaman_view');
	}

	public function home(){
		$this->load->view('home_pinjaman_view');
	}

	public function form_pengajuan(){
		$this->load->view('form_pengajuan_pinjaman_view');
	}

	public function data_mahasiswa(){
		$this->load->view('data_mahasiswa_pinjaman_view');
	}

}


?>