<?php
class SearchController extends Controller
{
    /**
     * @var string index dir as alias path from <b>application.</b>  , default to <b>runtime.search</b>
     */
    private $_indexFiles = 'runtime.search';
    /**
     * (non-PHPdoc)
     * @see CController::init()
     */
//    public function init(){
 //       Yii::import('application.vendors.*');
 //       require_once('Zend/Search/Lucene.php');
 //       parent::init(); 
 //   }
  
	public function actionSearch()
    {
        $this->layout='column2';
         if (($term = Yii::app()->getRequest()->getParam('q', null)) !== null) {
            $index = new Zend_Search_Lucene(Yii::getPathOfAlias('application.' . $this->_indexFiles));
            $results = $index->find($term);
            $query = Zend_Search_Lucene_Search_QueryParser::parse($term);       
 
            $this->render('/sParameter/search', compact('results', 'term', 'query'));
        }
    }	
	/**
     * Search index creation
     */
    public function actionCreate()
    {
        $index = new Zend_Search_Lucene(Yii::getPathOfAlias('application.' . $this->_indexFiles), true);
 
        $posts = tAccount::model()->findAll();
        foreach($posts as $post){
            $doc = new Zend_Search_Lucene_Document();
 
            $doc->addField(Zend_Search_Lucene_Field::Text('account_no',
                                          CHtml::encode($post->account_no), 'utf-8')
            );
 
            $doc->addField(Zend_Search_Lucene_Field::Text('short_description',
                                            CHtml::encode($post->short_description)
                                                , 'utf-8')
            );   
 
            $doc->addField(Zend_Search_Lucene_Field::Text('account_name',
                                          CHtml::encode($post->account_name)
                                          , 'utf-8')
            );
 
 
            $index->addDocument($doc);
        }
        $index->commit();
        echo 'Lucene index created';
    }	
	
}