/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wjhk.jupload2.context.JUploadContext;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadExceptionUploadFailedSuccessNotFound;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.filedata.PictureFileData;
import wjhk.jupload2.policies.PictureUploadPolicy;

public class CoppermineUploadPolicy
extends PictureUploadPolicy {
    private int albumId = this.getContext().getParameter("albumId", 0);
    private int nbPictureInUpload = 0;

    public CoppermineUploadPolicy(JUploadContext juploadContext) throws JUploadException {
        super(juploadContext);
    }

    public void onFileSelected(FileData fileData) {
        if (fileData != null && fileData instanceof PictureFileData) {
            super.onFileSelected(fileData);
        } else {
            super.onFileSelected(null);
        }
    }

    public void setProperty(String prop, String value) throws JUploadException {
        this.displayDebug("[CoppermineUploadPolicy] Call of setProperty: " + prop + " => " + value, 30);
        if (prop.equals("albumId")) {
            this.albumId = this.getContext().parseInt(value, 0);
            this.displayDebug("Post URL (modified in CoppermineUploadPolicy) = " + this.getPostURL(), 10);
        } else {
            super.setProperty(prop, value);
        }
    }

    public String getPostURL() {
        String postURL = super.getPostURL();
        return postURL + (postURL.contains("?") ? "&" : "?") + "album=" + this.albumId;
    }

    public boolean beforeUpload() {
        if (this.albumId <= 0) {
            this.alert("chooseAlbumFirst");
            return false;
        }
        this.nbPictureInUpload = this.getContext().getUploadPanel().getFilePanel().getFilesLength();
        return super.beforeUpload();
    }

    public void afterUpload(Exception e, String serverOutput) throws JUploadException {
        int nbPictureAfterUpload = this.getContext().getUploadPanel().getFilePanel().getFilesLength();
        if (nbPictureAfterUpload > this.nbPictureInUpload) {
            this.displayErr("CoppermineUploadPolicy.afterUpload: The number of uploaded files is negative! (" + (this.nbPictureInUpload - nbPictureAfterUpload) + ")");
        } else if (nbPictureAfterUpload == this.nbPictureInUpload) {
            this.displayWarn("CoppermineUploadPolicy.afterUpload: No file were uploaded! (" + (nbPictureAfterUpload - this.nbPictureInUpload) + ")");
        } else if (this.getDebugLevel() >= 100) {
            this.alertStr("No switch to property page, because debug level is " + this.getDebugLevel() + " (>=100)");
        } else if (e == null) {
            this.alert("coppermineUploadOk");
            String postURL = this.getPostURL();
            if (postURL.contains("/upload.php?")) {
                this.setAfterUploadURL(postURL.substring(0, this.getPostURL().lastIndexOf("/upload.php?")) + "/index.php?file=jupload/jupload&action=edit_uploaded_pics&album=" + this.albumId + "&nb_pictures=" + (this.nbPictureInUpload - nbPictureAfterUpload));
            } else {
                this.setAfterUploadURL(postURL.substring(0, this.getPostURL().lastIndexOf(47)) + "/jupload&action=edit_uploaded_pics&album=" + this.albumId + "&nb_pictures=" + (this.nbPictureInUpload - nbPictureAfterUpload));
            }
            super.afterUpload(e, serverOutput);
        }
    }

    public boolean checkUploadSuccess(int status, String msg, String body) throws JUploadException {
        try {
            return super.checkUploadSuccess(status, msg, body);
        }
        catch (JUploadExceptionUploadFailedSuccessNotFound e) {
            Pattern patternMessage = Pattern.compile(".*cpg_user_message\">(.*)</span>");
            Pattern pMultiline = Pattern.compile("[\\r\\n]", 8);
            String[] lines = pMultiline.split(body);
            StringBuffer sbBodyWithUniformCRLF = new StringBuffer(body.length());
            for (int i = 0; i < lines.length; ++i) {
                Matcher matcherMessage;
                String line = lines[i];
                sbBodyWithUniformCRLF.append(line).append("\r\n");
                if (line == null || line.equals("") || !(matcherMessage = patternMessage.matcher(line)).matches()) continue;
                String errmsg = "An error occurs during upload (but the applet couldn't find the error message)";
                if (matcherMessage.groupCount() > 0 && !matcherMessage.group(1).equals("")) {
                    errmsg = this.formatMessage(matcherMessage.group(1));
                }
                this.lastResponseMessage = errmsg;
                throw new JUploadExceptionUploadFailed(errmsg);
            }
            throw e;
        }
    }

    public void displayParameterStatus() {
        super.displayParameterStatus();
        this.displayDebug("======= Parameters managed by CoppermineUploadPolicy", 30);
        this.displayDebug("albumId : " + this.albumId, 30);
        this.displayDebug("", 30);
    }
}

